/*
 * 	DCM.c
 *
 *  Created on: Aug 23, 2010
 *  Author: Jared Rought
 *
 *  Function: Provides the directional cosine matrix for self-stabilization calculations.
 */

#include "DCM.h"
#include "stm32f10x.h"

#define T .02
#define KPXY 0.0001
#define KIXY 0.0000005
#define KPZ 0.5
#define KIZ 0.0005

void PILoop(float* OmegaP, float* OmegaI, float* ErrorXY, float* ErrorZ);
void matrixMult(float MatOut[][3], float Mat1[][3], float Mat2[][3]);
void matrixAdd(float MatOut[][3], float Mat1[][3], float Mat2[][3]);
void vectorCross(float* CrossOut, float* v1, float* v2);
float vectorDot(float* v1, float* v2);
void vectorAdd(float* vOut, float* v1, float* v2);
void vectorScale(float* vOut, float* vIn, float ScaleFactor);

//Global DCM Variables
float Gyros[3] = {0, 0, 0};
float Accels[3] = {0, 0, 0};
float Omega[3] = {0, 0, 0};
float OmegaI[3] = {0, 0, 0};
float OmegaP[3] = {0, 0, 0};
float ErrorXY[3] = {0,0,0};
float ErrorZ[3] = {0,0,0};
float ErrorXYScaled[3] = {0,0,0};

//Base Rotational Matrix
float Rmat[3][3] = {
		{1,0,0},
		{0,1,0},
		{0,0,1}
};
int i,j,k;











//This function updates the rotational matrix based on the measured gyro values,
//Then subsequently normalizes the matrix to compensate for accumulated numerical
//integration errors.
void updateRmat(void){
	//local variables
	float RmatUpdated[3][3];
	float RmatTemp[3][3];

	 // Update gyros vector and apply signs
	Gyros[0] = -GyroCon[0]; // x gyro
	Gyros[1] = -GyroCon[1]; // y gyro
	Gyros[2] = -GyroCon[2]; // z gyro
	Accels[0] = -AccCon[0]; // x accel
	Accels[1] = -AccCon[1]; // y accel
	Accels[2] = -AccCon[2]; // z accel

	// Add proportional and integral terms
	vectorAdd(Omega, GyroCon, OmegaI);
	vectorAdd(Omega, Omega, OmegaP);

	RmatUpdated[0][0] = 1;
	RmatUpdated[0][1] = Omega[2]*T;  //z
	RmatUpdated[0][2] = -Omega[1]*T; //-y
	RmatUpdated[1][0] = -Omega[2]*T; //-z
	RmatUpdated[1][1] = 1;
	RmatUpdated[1][2] = Omega[0]*T; //x
	RmatUpdated[2][0] = Omega[1]*T; //y
	RmatUpdated[2][1] = -Omega[0]*T;//-x
	RmatUpdated[2][2] = 1;

	matrixMult(RmatTemp, Rmat, RmatUpdated);
	matrixAdd(Rmat, Rmat, RmatTemp);

	normRmat();

}

//DCM normalizing function
void normRmat(void){

	float error;
	float normalized;
	float Xorthog[3] = {0, 0, 0};
	float Yorthog[3] = {0, 0, 0};
	float Zorthog[3] = {0, 0, 0};

						//X vector  //Y vector
	error = -vectorDot(&Rmat[0][0], &Rmat[1][0])*0.5; //error scaling factor

	//X orthogonal vector
	vectorScale(Xorthog, &Rmat[1][0], error);
	vectorAdd(Xorthog, Xorthog, &Rmat[0][0]);

	//Y orthogonal vector
	vectorScale(Yorthog, &Rmat[0][0], error);
	vectorAdd(Yorthog, Yorthog, &Rmat[1][0]);

	//Z orthogonal vector
	vectorCross(Zorthog, Xorthog, Yorthog);

	//Taylor's Expansion
	//X normalized
	normalized = 0.5*(3-vectorDot(Xorthog, Xorthog));
	vectorScale(&Rmat[0][0], Xorthog, normalized);

	//Y normalized
	normalized = 0.5*(3-vectorDot(&Yorthog[0], &Yorthog[0]));
	vectorScale(&Rmat[1][0], Yorthog, normalized);

	//Z normalized
	normalized = 0.5*(3-vectorDot(&Zorthog[0], &Zorthog[0]));
	vectorScale(&Rmat[2][0], Zorthog, normalized);
}

//Gyro drift compensation function. This function compensates for pitch, roll and yaw drift
void correctRmat(void){

	//Roll and Pitch Correction
	vectorCross(ErrorXY, &Rmat[2][0], AccCon);

	//Yaw Correction
	/*//Magnetometer heading calculation
	COGX = Magno[0] / Magnitude;
	COGY = Magno[1] / Magnitude;

	YawCorrectionGround = Rmat[0][0]*COGX - Rmat[1][0]*COGY;
	vectorScale(YawCorrectionPlane, Rmat[2], YawCorrectionGround);
	YawCorrectionPlane = ErrorZ;
	*/
}

//PI loop function for utilizing the error that was calculated by the drift compensation function
void PILoop(float* OmegaP, float* OmegaI, float* ErrorXY, float* ErrorZ) {

	float OmegaITemp[3] = {0,0,0};


	vectorScale(OmegaP, ErrorXY, KPXY);
	vectorScale(OmegaITemp, ErrorXY, KIXY);
	vectorAdd(OmegaI, OmegaI, OmegaITemp);

/*
	vectorScale(OmegaP, ErrorZ, KPZ);
	vectorScale(ErrorXYScaled, ErrorXY, KPXY);
	vectorAdd(OmegaP, OmegaP, ErrorXYScaled);

	vectorScale(OmegaITemp, ErrorZ, KIZ);
	vectorScale(ErrorXYScaled, ErrorXY, KIXY);
	vectorAdd(OmegaI, OmegaI, ErrorXYScaled);

	vectorAdd(OmegaI, OmegaI, OmegaITemp); */
}

//DCM arithmatic

//Matrix operations
void matrixMult(float MatOut[3][3], float Mat1[3][3], float Mat2[3][3]){

	float MatTemp[3];

	for(i=0;i<3;i++){
		for(j=0;j<3;j++){
			for(k=0;k<3;k++){
				MatTemp[k] = Mat1[j][k]*Mat2[j][k];
			}
			MatOut[i][j] = MatTemp[1] + MatTemp[2]+ MatTemp[3];
		}
	}
}

void matrixAdd(float MatOut[3][3], float Mat1[3][3], float Mat2[3][3]){


	for(i=0;i<3;i++){
		for(j=0;j<3;j++){
			MatOut[i][j] = Mat1[i][j] + Mat2[i][j];
		}
	}
}

void vectorCross(float* CrossOut, float* v1, float* v2){
	CrossOut[0] = (v1[1]*v2[2]) - (v1[2]*v2[1]);
	CrossOut[1] = (v1[2]*v2[0]) - (v1[0]*v2[2]);
	CrossOut[2] = (v1[0]*v2[1]) - (v1[1]*v2[0]);
}

//Vector Operations
float vectorDot(float* v1, float* v2){
	float dot = 0;


	for(i=0;i<3;i++){
		dot += v1[i]*v2[i];
	}return dot;
}

void vectorAdd(float* vOut, float* v1, float* v2){


	for(i=0;i<3;i++){
		vOut[i] = v1[i] + v2[i];
	}
}

void vectorScale(float* vOut, float* vIn, float ScaleFactor){


	for(i=0;i<3;i++){
		vOut[i] = vIn[i]*ScaleFactor;
	}
}
